//=============================================================================
// Balloon subclass for zeppelin balloons, never spawned (on purpose lol!!)
//=============================================================================
class Balloon_zeppelin extends Balloon;

#exec obj load file=..\Textures\PopBalloonsTextures.utx package=PopBalloonsTextures
#exec obj load file=..\Textures\Indus5.utx package=Indus5
#exec mesh import mesh=Zeppelin anivfile=Models\Zeppelin_a.3d datafile=Models\Zeppelin_d.3d x=0 y=0 z=0 mlod=0
#exec mesh origin mesh=Zeppelin x=0 y=0 z=0
#exec mesh sequence mesh=Zeppelin seq=All startframe=0 numframes=1
#exec meshmap new meshmap=Zeppelin mesh=Zeppelin
#exec meshmap scale meshmap=Zeppelin x=0.23438 y=0.23438 z=0.46875

/* zeppelin balloons group contains the following balloons:
	- red 		(layers: 100, speed: 0.500000, key: v)
	- blue		(layers: 200, speed: 0.400000, key: w)
	- green		(layers: 300, speed: 0.300000, key: x)
	- Yellow	(layers: 400, speed: 0.250000, key: y)
	- Purple	(layers: 500, speed: 0.200000, key: z)
*/

function PlayDeathHit(float Damage, vector HitLocation, name damageType, vector Momentum)
{
local UT_SpriteBallExplosion s;
local Balloon_zeppelin_blue ZB;
local Balloon_zeppelin_red ZR;
local Balloon_zeppelin_green ZG;
local Balloon_zeppelin_yellow ZY;

	s = spawn(class'UT_SpriteBallExplosion',,,Self.Location);
	S.DrawScale = DrawScale * 2.5;
 	s.RemoteRole = ROLE_None;

	if ( Self.IsA('Balloon_zeppelin_blue') )
		{
		ZR = Spawn(Class'Balloon_zeppelin_red', , , Self.Location);
		ZR.DefineBalloonPathNodes();
		ZR.Airspeed = ZR.BaseSpeed * ZR.speed;
		ZR.GotoState('TacticalMove');
		ZR.NextPath = Self.NextPath;
		ZR.PathNum = Self.PathNum;
		if ( bCamo )
			{
			ZR.bCamo = True;
			ZR.Style = STY_Translucent;
			}
		}
	else if ( Self.IsA('Balloon_zeppelin_green') )
		{
		ZB = Spawn(Class'Balloon_zeppelin_blue', , , Self.Location);
		ZB.DefineBalloonPathNodes();
		ZB.Airspeed = ZB.BaseSpeed * ZB.speed;
		ZB.GotoState('TacticalMove');
		ZB.NextPath = Self.NextPath;
		ZB.PathNum = Self.PathNum;
		if ( bCamo )
			{
			ZB.bCamo = True;
			ZB.Style = STY_Translucent;
			}
		}
	else if ( Self.IsA('Balloon_zeppelin_yellow') )
		{
		ZG = Spawn(Class'Balloon_zeppelin_green', , , Self.Location);
		ZG.DefineBalloonPathNodes();
		ZG.Airspeed = ZG.BaseSpeed * ZG.speed;
		ZG.GotoState('TacticalMove');
		ZG.NextPath = Self.NextPath;
		ZG.PathNum = Self.PathNum;
		if ( bCamo )
			{
			ZG.bCamo = True;
			ZG.Style = STY_Translucent;
			}
		}
	else if ( Self.IsA('Balloon_zeppelin_purple') )
		{
		ZY = Spawn(Class'Balloon_zeppelin_yellow', , , Self.Location);
		ZY.DefineBalloonPathNodes();
		ZY.Airspeed = ZY.BaseSpeed * ZY.speed;
		ZY.GotoState('TacticalMove');
		ZY.NextPath = Self.NextPath;
		ZY.PathNum = Self.PathNum;
		if ( bCamo )
			{
			ZY.bCamo = True;
			ZY.Style = STY_Translucent;
			}
		}
		
 	Self.Destroy();
}

function SetColor()
{
}

defaultproperties
{
	 layers=100
	 speed=0.500000
     DrawType=DT_Mesh
	 Mesh=Mesh'Zeppelin'
     AmbientGlow=64
     CollisionRadius=60.00000
	 CollisionHeight=20.00000
	 AmbientSound=Sound'BotPack.ChainSaw.ChainIdle'
	 SoundRadius=40
     SoundVolume=220
	 bCanBeGlued=False
	 bCanBeFrozen=False
}
